/*
 *      NoMotion.POV
 *      The Perpetual motion machine that has somehow gone very wrong!
 *
 *      By Steven L. Reid
 *      26 May 97
 */

// Global Settings
#version 3.0
global_settings {
    assumed_gamma 2.2
    max_trace_level 10
}

// Includes
#include "colors.inc"
#include "textures.inc"

// Create Frame
#declare Brace = box { <0,0,0>, <5,120,5> }
#declare Support = cylinder { <0,2.5,2.5>, <150,2.5,2.5>, 2.5 }

union { //Frame
    box { <0,0,0>, <170,5,90> }
    object { Brace translate <  5,5, 5> }
    object { Brace translate <160,5, 5> }
    object { Brace translate <  5,5,80> }
    object { Brace translate <160,5,80> }
    object { Support translate <10,115, 5> }
    object { Support translate <10,115,80> }
    pigment { color rgb <0.53, 0.40, 0.07> }
    finish {ambient 0.3 phong 0.6 phong_size 30}
    translate <-85, 0, -45>
}

// Add Balls
#declare MetalBall =
    sphere { <0,-60,0>, 15
        pigment { White }
        finish {
            reflection 0.7 ambient 0 diffuse 0
            phong .6 phong_size 30
        }
    }
#declare Brace =
    merge {
        triangle { <0,-45,0>, <2.5,0,-35>, <2.5,0,35> }
        triangle { <0,-45,0>, <-2.5,0,-35>, <-2.5,0,35> }
        triangle { <0,-45,0>, <2.5,0,-35>, <-2.5,0,-35> }
        triangle { <0,-45,0>, <2.5,0,35>, <-2.5,0,-35> }
        triangle { <2.5,0,-35>, <-2.5,0,-35>, <2.5,0,35> }
        triangle { <2.5,0,35>, <-2.5,0,35>, <-2.5,0,-35> }
        pigment {color red .9 }
        finish { ambient 0.3 diffuse 0.5 reflection 0.3 }
    }
#declare Ball =
    union {
        object {MetalBall}
        object {Brace}
    }

// object { Ball rotate (clock-45)*z translate <-60,120,0> }
// Exploding Ball
object { Brace translate <-60,120,0> }
sphere { <0,-60,0>, 15
    pigment { color rgbt <1, 1, 1, .5>}
    finish {
        reflection 0.7 ambient 0 diffuse 0
        phong .6 phong_size 30
    }
    translate <-60,120,0>
    hollow
}
// explosion
sphere {  <0,0,0>,1 // <0,-60,0>, 15
    pigment { color rgbt <1, 1, 1, 1>}
    halo {
        emitting
        spherical_mapping
        linear
        turbulence 1.5
        color_map {
            [ 0.0 color rgbt <1, 0, 0,  1> ]
            [ 0.5 color rgbt <1, 1, 0, -1> ]
            [ 1.0 color rgbt <1, 0, 0,  1> ]
        }
        frequency 2
        samples 20
        scale 0.5
    }
    hollow
    scale 35
    translate <-60,60,0>
}
// shoot of flame
cone {  <0,0,0>,.5,<0,1,0>,1
    pigment { color rgbt <1, 1, 1, 1>}
    halo {
        emitting
        cylindrical_mapping
        linear
        turbulence 1.5
        color_map {
            [ 0.0 color rgbt <1, 0, 0,  1> ]
            [ 0.5 color rgbt <1, 1, 0, -1> ]
            [ 1.0 color rgbt <1, 0, 0,  1> ]
        }
        frequency 2
        samples 20
        scale 0.4
    }
    hollow
    scale <15,75,15>
    translate <-60,60,0>
}
// Rest of balls
object { Ball translate <-30,120,0> }
object { Ball translate <  0,120,0> }
object { Ball translate < 30,120,0> }
object { Ball translate < 60,120,0> }


sphere { // Sky
    <0,0,0>, 1
    pigment{Bright_Blue_Sky scale .25}
    finish {crand 0.05}
    scale 2000
    hollow
}

plane { // Ground
    y,0
    pigment {
        checker color rgb<0.1,0.5,0.2> color rgb<0.2,0.3,0.8>
        scale 60
    }
    finish { crand 0.05 reflection 0.1 }
    hollow
}

// Add some light!
light_source { <100,200,-100> color White }
light_source { <-100,200,100> color White }

camera {location <-50,70,200> look_at <0,65,0>}
